package gov.va.vinci.dart.json.builder;

import gov.va.vinci.dart.biz.Group;
import gov.va.vinci.dart.biz.Role;
import gov.va.vinci.dart.json.RoleAndGroupListView;
import gov.va.vinci.dart.json.RoleAndGroupView;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import org.springframework.stereotype.Component;

@Component
public class RoleAndGroupListViewBuilder {

	public static boolean isRequestor( final Collection<Role> roleList, final Collection<Group> groupList ) {
	
		Group.initialize();
		Role.initialize();
		
		//add the Requestor role?
		if( (groupList == null || groupList.isEmpty()) ) {	//no group

			if( (roleList == null || roleList.isEmpty() == true) ) {
				return true;
				
			} else {
				for( Role role : roleList ) {
					if( role != null ) {
						
						if( role.getId() == Role.NDS_ADMIN.getId() ) {	//NDS Admin cannot initiate requests
							return false;
						}

						if( role.getId() == Role.SUPER_USER.getId() ) {	//DART Admin cannot initiate requests
							return false;
						}

						if( role.getId() == Role.REVIEWER.getId() || role.getId() == Role.READ_ONLY_STAFF.getId() ) {	//reviewer cannot initiate requests
							return false;
						}
						
					}//end if -- role
				}//end for -- role
			}//end else

			return true;
		}//end if -- group
		
		return false;
	}


	public static RoleAndGroupView getRequestorView() {
		RoleAndGroupView requestorView = new RoleAndGroupView();

		requestorView.setRoleId(0);
		requestorView.setGroupId(0);
		requestorView.setDisplayName("Requestor");
		requestorView.setDisplayOrder(-100);

		return requestorView;
	}
	
	
	@SuppressWarnings("unchecked")
	public RoleAndGroupListView build( final Collection<Role> roleList, final Collection<Group> groupList ) {
		
		RoleAndGroupListView result = new RoleAndGroupListView();

		Group.initialize();
		Role.initialize();


		//add the Requestor role?
		if( (groupList == null || groupList.isEmpty()) ) {	//no group

			if( isRequestor(roleList, groupList) ) {
				result.setRequestor(true);

				RoleAndGroupView view = getRequestorView();
				result.getRolesAndGroups().add(view);
			}//end if

		}//end if

		for( Role role : roleList ) {
			if( role != null ) {

				//add the Admin Tool role?
				if( role.getId() == Role.ADMINISTRATOR.getId() ) {
					result.setJanitor(true);

				} else {	//role other than the Admin Tool

					if( groupList != null ) {
						for( Group group : groupList ) {
	
							RoleAndGroupView view = new RoleAndGroupView();
							
							view.setRoleId(role.getId());
							view.setGroupId(group.getId());
							view.setDisplayName( group.getShortName() + " " + role.getShortName() );

							result.getRolesAndGroups().add(view);

						}//end for -- group
					}//end if
				}//end else

			}//end if -- role
		}//end for -- role


		Collections.sort(result.getRolesAndGroups());
		
		return result;
	}
	
	
	@SuppressWarnings("unchecked")
	public RoleAndGroupListView buildAllRolesAndGroups() {
		
		RoleAndGroupListView result = new RoleAndGroupListView();

		Group.initialize();
		Role.initialize();


		//add the Requestor role
		RoleAndGroupView requestorView = getRequestorView();
		result.getRolesAndGroups().add(requestorView);


		List<Group> groupList = Group.listAll();

		if( groupList != null ) {
			for( Group group : groupList ) {
				if( group != null ) {
					
					Set<Role> roleSet = group.getSupportedRoles();
					if( roleSet != null ) {

						for( Role role : roleSet ) {
							if( role != null ) {

								RoleAndGroupView view = new RoleAndGroupView();
	
								view.setRoleId(role.getId());
								view.setGroupId(group.getId());
								view.setDisplayName( group.getShortName() + " " + role.getShortName() );
	
								if( group.getId() == Group.DART_ADMIN.getId() ) {
									view.setDisplayOrder(100);
								}
								
								result.getRolesAndGroups().add(view);

							}//end if							
						}//end for
						
					}//end if
				}//end if
			}//end for
		}//end if

		
		Collections.sort(result.getRolesAndGroups());
		
		return result;
	}
}
